/*!
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANTÍAS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

jQuery(document).ready(function(){
		
	
	//idioma
	//$("#aa17aCalidadAireWar_language").rup_language({languages: $.rup.AVAILABLE_LANGS_ARRAY});
	
	//configuro automáticamente todos los campos fecha para que salga el calendario
	$(".campoFecha").rup_date();
	
	//configuramos el feedback para los mensajes de todas las pantallas
	$("#feedbackMensajes").rup_feedback({
		type: "ok",
		closeLink: true,
		block: false,
		gotoTop: true
	});	
});

function blockUI_Cargando()
{
	 $.blockUI({
		   message: '<img src="' + $.rup.RUP + '/basic-theme/images/rup.ajaxLoader.gif" style="position:absolute;top:12px;left:15px;z-index:100000" alt="' + $.rup.i18n.base.rup_blockUI.cargando + '" ><h3 class="loading">' + $.rup.i18n.base.rup_blockUI.cargando + '...' + '</h3>',
		   baseZ: 2000 //para que siempre salga por encima de todas las ventanas
		});    
}

function cargarAvisosGenerales(){
	
	//configuro el link de ocultar el panel de avisos generales
	$("#aCerrarAvisoGeneral").click(function(){
		$("#divAvisosGenerales").hide("fade");
	});
	
	//obtengo la lista de avisos generales
	$.rup_ajax({
		url: $.rup.CTX_PATH+"avisos/generales",
		dataType: 'json',
		type: "GET",
		async: false,
		contentType: 'application/json',		    
		success: function (resultado, ajaxOptions) {
			//si existen avisos generales
			if (resultado.length > 0){
				//cargo la lista de avisos generales
				for (var i=0; i<resultado.length; i++){
					
					var div = $(document.createElement("div"));
					$(div).text("- " + resultado[i].textoAviso);
					
					$("#pAvisosGenerales").append($(div));
				}
			}else{
				//si no hay avisos generales, oculto el bloque
				$("#divAvisosGenerales").hide();
			}
			
		},
		error: function (xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			$.unblockUI();
		}
	});
}

/*
 * Metodo que devuelve los meses de diferencia entre 2 fechas
 */
function monthsDiff(fecha1, fecha2) {
	
	var firstDate, secondDate;
	
	if ($.rup.lang == "es"){
		firstDate = new Date(fecha1.split("/")[2], fecha1.split("/")[1], fecha1.split("/")[0]);
		secondDate = new Date(fecha2.split("/")[2], fecha2.split("/")[1], fecha2.split("/")[0]);
	}else{
		firstDate = new Date(fecha1.split("/")[0], fecha1.split("/")[1], fecha1.split("/")[2]);
		secondDate = new Date(fecha2.split("/")[0], fecha2.split("/")[1], fecha2.split("/")[2]);
	}

    var fm = firstDate.getMonth();
    var fy = firstDate.getFullYear();
    var sm = secondDate.getMonth();
    var sy = secondDate.getFullYear();
    var months = Math.abs(((fy - sy) * 12) + fm - sm);
    var firstBefore = firstDate > secondDate;
    firstDate.setFullYear(sy);
    firstDate.setMonth(sm);
    firstBefore ? firstDate < secondDate ? months-- : "" : secondDate < firstDate ? months-- : "";
    return months;
}